% Objective: iFBA with Monod kinetic model and dFBA, 
% The objective function is assumed to be 
% 1) maximize growth rate
% 2) tradeoff between "maximize growth rate" and "minimize overall fluxes"
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% Date: 09/01/2011

function f=getSimulationGap(param)
%% Assign initial guess of Monod parameters 
S=xlsread('Matrix_final.xlsx',1);
boundary=xlsread('Matrix_final.xlsx',2);
obj_S=zeros(1,775);
obj_S(775)=1;


%% Simulate the biomass and substrate kinetics 
num_timepoint=408;

LACT_Timeprofile=zeros(num_timepoint,1);
ACT_Timeprofile=zeros(num_timepoint,1);
PYR_Timeprofile=zeros(num_timepoint,1);
Biomass_Timeprofile=zeros(num_timepoint,1);

LACT_ini=29.64;
ACT_ini=0.02;
PYR_ini=0.01;
Biomass_ini=0.00045738;
dt=34/num_timepoint;

LACT_Timeprofile(1)=LACT_ini;
ACT_Timeprofile(1)=ACT_ini;
PYR_Timeprofile(1)=PYR_ini;
Biomass_Timeprofile(1)=Biomass_ini;

umax_L=param(1);
umax_A=param(2);
umax_P=param(3);
Ksl=param(4);
Ksa=param(5);
Ksp=param(6);
kpl=param(7);
kal=param(8);
kap=param(9);
ke=param(10);
tL=param(11)/dt;
Yxl=param(12);
Yxa=param(13);
Yxp=param(14);

flux_LACT_inflow=zeros(num_timepoint,1);
flux_ACT_outflow=zeros(num_timepoint,1);
flux_PYR_outflow=zeros(num_timepoint,1);

lambda_Timeprofile=zeros(num_timepoint,1);
flux_Timeprofile=zeros(num_timepoint,775);

for time=1:num_timepoint-1
    u_L=umax_L*LACT_Timeprofile(time)/(Ksl+LACT_Timeprofile(time));
    u_A=umax_A*ACT_Timeprofile(time)/(Ksa+ACT_Timeprofile(time));
    u_P=umax_P*PYR_Timeprofile(time)/(Ksp+PYR_Timeprofile(time));
    
    if((time-tL)<0)
       coeff=0; 
    else
       coeff=1; 
    end
    
    flux_LACT_inflow(time)=-(-u_L/Yxl-kpl*LACT_Timeprofile(time)-kal*LACT_Timeprofile(time))*coeff;
    flux_ACT_outflow(time)=(kal*LACT_Timeprofile(time)+kap*PYR_Timeprofile(time)-u_A/Yxa)*coeff;
    flux_PYR_outflow(time)=(kpl*LACT_Timeprofile(time)-u_P/Yxp-kap*PYR_Timeprofile(time))*coeff;

    if(flux_ACT_outflow(time,1)>0||flux_LACT_inflow(time,1)>0||flux_PYR_outflow(time,1)>0)
        
        %For "maximize growth rate" objective function, use the following weight 
        weight=0;
        
        %For "maximize growth rate" objective function, use the following weight 
        %if(time<param(17)*12)
        %    weight=param(15);
        %    time_critical=time;
        %else
        %    weight=param(15)*exp(param(16)*(time-time_critical)/12);
        %end
                
        %%%%%%%%%TOMLAB%%%%%%%%%%%%%%%%
        
        F=eye(775).*2.*weight;
        c=-obj_S'.*(1-weight);
        A=S;
        
        lb=boundary(:,2);
        ub=boundary(:,1);
        
        lb(426)=flux_LACT_inflow(time,1);
        ub(426)=flux_LACT_inflow(time,1);
        lb(39)=-flux_ACT_outflow(time,1);
        ub(39)=-flux_ACT_outflow(time,1);
        lb(634)=-flux_PYR_outflow(time,1);
        ub(634)=-flux_PYR_outflow(time,1);
        
        b_L=zeros(634,1);
        b_U=zeros(634,1);
        x_L=lb;
        x_U=ub;
        x_0=[];
        
        %For tradeoff objective function, use the following command
        %Prob = qpAssign(F, c, A, b_L, b_U, x_L, x_U, x_0,[],...
        %    [], [], [], [], []);
        
        %For "maximize growth rate" objective function, use the following command
        Prob = lpAssign(c, A, b_L, b_U, x_L, x_U, x_0,[],...
            [], [], [], [], []);
        
        Result = tomRun('cplex', Prob, 0);
        
        lambda_Value=-Result.f_k;
        flux_Value=Result.x_k;
        
        lambda_Timeprofile(time,1)=lambda_Value;
        flux_Timeprofile(time,:)=flux_Value;
    end
    next_time=time+1;
    Biomass_Timeprofile(next_time,1)=Biomass_Timeprofile(time,1)*(lambda_Timeprofile(time,1)-ke)*dt+Biomass_Timeprofile(time,1);
    LACT_Timeprofile(next_time,1)=-flux_LACT_inflow(time,1)*Biomass_Timeprofile(time,1)*dt+LACT_Timeprofile(time,1);
    ACT_Timeprofile(next_time,1)=flux_ACT_outflow(time,1)*Biomass_Timeprofile(time,1)*dt+ACT_Timeprofile(time,1);
    PYR_Timeprofile(next_time,1)=flux_PYR_outflow(time,1)*Biomass_Timeprofile(time,1)*dt+PYR_Timeprofile(time,1);
end


%% calculate the differences between simulations and measurements
XObs=[0.000328030303030303;0.00984090909090909;0.0203378787878788;0.0183696969696970;0.0288666666666667;0.0531409090909091;0.0846318181818182;0.0833196969696970;0.0918484848484849;0.100377272727273;0.112842424242424;0.139740909090909;0.201410606060606;0.215187878787879;0.246678787878788;0.328030303030303;0.326718181818182;0.322125757575758;0.000328030303030303;0.0164015151515152;0.0249303030303030;0.0255863636363636;0.0321469696969697;0.0629818181818182;0.0649500000000000;0.0793833333333333;0.110218181818182;0.116122727272727;0.148269696969697;0.200098484848485;0.219780303030303;0.249959090909091;0.289978787878788;0.331966666666667;0.338527272727273;0.372642424242424;0.000328030303030303;0.0118090909090909;0.0229621212121212;0.0183696969696970;0.0314909090909091;0.0728227272727273;0.0715106060606061;0.0944727272727273;0.0997212121212121;0.0997212121212121;0.116778787878788;0.167295454545455;0.228309090909091;0.242086363636364;0.271609090909091;0.351648484848485;0.359521212121212;0.353616666666667;];
LACTObs=[30.3600000000000;27.8600000000000;26.0800000000000;25.3600000000000;25.3600000000000;22.8900000000000;20.7200000000000;20.2200000000000;18.5700000000000;16.2900000000000;13.4700000000000;8.08000000000000;2.79000000000000;0.110000000000000;0.110000000000000;0;0.0700000000000000;0.0700000000000000;29.2800000000000;26.4300000000000;26.4300000000000;24.2900000000000;21.7900000000000;19.5400000000000;18.5400000000000;18.0700000000000;21.5700000000000;12.9300000000000;9.12000000000000;3.33000000000000;0.180000000000000;0.110000000000000;0.110000000000000;0.0900000000000000;0;0;29.2900000000000;28.2200000000000;27.8600000000000;26.0700000000000;23.9300000000000;23.8900000000000;21.5700000000000;21;15.8600000000000;16.7600000000000;13.6900000000000;8.15000000000000;2.29000000000000;0.110000000000000;0.0400000000000000;0.0500000000000000;0.0500000000000000;0;];
ACTObs=[0.0200000000000000;0.270000000000000;0.480000000000000;0.790000000000000;1.19000000000000;1.12000000000000;1.31000000000000;1.75000000000000;2.11000000000000;2.72000000000000;3.48000000000000;4.56000000000000;6.44000000000000;7.57000000000000;7.81000000000000;6.99000000000000;3.83000000000000;0.970000000000000;0.0100000000000000;0.270000000000000;0.500000000000000;0.820000000000000;1.30000000000000;1.21000000000000;1.48000000000000;2.02000000000000;2.56000000000000;3.14000000000000;4.06000000000000;6.37000000000000;6.84000000000000;7.06000000000000;8.11000000000000;2.97000000000000;0.0700000000000000;0.0200000000000000;0.0200000000000000;0.280000000000000;0.510000000000000;0.870000000000000;1.33000000000000;1.22000000000000;1.39000000000000;1.93000000000000;2.12000000000000;2.89000000000000;3.74000000000000;5.20000000000000;7.05000000000000;8.03000000000000;6.13000000000000;6.91000000000000;3.74000000000000;0.800000000000000;];
PYRObs=[0.0100000000000000;0.0100000000000000;0.0100000000000000;0.0400000000000000;0.130000000000000;0.250000000000000;0.330000000000000;0.570000000000000;0.460000000000000;1.15000000000000;2.06000000000000;2.91000000000000;4.12000000000000;3.27000000000000;1.75000000000000;0;0;0.0100000000000000;0.0100000000000000;0.0100000000000000;0.0100000000000000;0.0500000000000000;0.200000000000000;0.300000000000000;0.620000000000000;0.830000000000000;0.990000000000000;1.62000000000000;2.59000000000000;3.56000000000000;3.20000000000000;1.96000000000000;1.57000000000000;0.0200000000000000;0;0;0.0100000000000000;0.0200000000000000;0.0100000000000000;0.0300000000000000;0.110000000000000;0.200000000000000;0.250000000000000;0.540000000000000;1.20000000000000;1.30000000000000;1.88000000000000;2.91000000000000;4.12000000000000;3.27000000000000;0;0;0;0;];

error_X=0;
error_LACT=0;
error_ACT=0;
error_PYR=0;

TimeMeasured=[1;132;156;180;204;216;228;240;252;264;282;300;318;336;354;372;390;408;1;132;156;180;204;216;228;240;252;264;282;300;318;336;354;372;390;408;1;132;156;180;204;216;228;240;252;264;282;300;318;336;354;372;390;408];


for j=1:length(TimeMeasured)
    checkpoint=TimeMeasured(j);
    error_X=error_X+((Biomass_Timeprofile(checkpoint)-XObs(j))/max(XObs))^2;
    error_LACT=error_LACT+((LACT_Timeprofile(checkpoint)-LACTObs(j))/max(LACTObs))^2;
    error_ACT=error_ACT+((ACT_Timeprofile(checkpoint)-ACTObs(j))/max(ACTObs))^2;
    error_PYR=error_PYR+((PYR_Timeprofile(checkpoint)-PYRObs(j))/max(PYRObs))^2;
end

f=error_X+error_LACT+error_ACT+error_PYR;




















