function dy = Monod_kinetics_final(t,y) 
% objective: run the Monod model by inputing the global parameters
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% date: 09/01/2011

    global umax_L;
    global umax_A;
    global umax_P;
    global Ksl;
    global Ksa;
    global Ksp;
    global kpl;
    global kal;
    global kap;
    global Yxl;
    global Yxa;
    global Yxp;
    global ke;
    global tL;

    X=y(1);
    LACT=y(2);
    ACT=y(3);
    PYR=y(4);
    u_L=umax_L*LACT/(Ksl+LACT);
    u_A=umax_A*ACT/(Ksa+ACT);
    u_P=umax_P*PYR/(Ksp+PYR);
    r_pl=kpl*LACT*X;
    r_al=kal*LACT*X;
    r_ap=kap*PYR*X;

    dy(1)=(X*(u_L+u_A+u_P-ke))*heaviside(t-tL);                   %X
    dy(2)= (-X*u_L/Yxl-r_pl-r_al)*heaviside(t-tL);                %LACT
    dy(3)= (r_al+r_ap-X*u_A/Yxa)*heaviside(t-tL);                 %ACT
    dy(4)= (r_pl-X*u_P/Yxp-r_ap)*heaviside(t-tL);                 %PYR
dy=dy';
end