function [dcdt] = hynne(t,C)

%up funwt, mb fr wt

global v3m v4m v5m v6f v8m v10m v11m v12m v15m k23 k24f k24r kbio kco2
t

%--------------------------------
%KONCENTRATIONER I MB
%--------------------------------
conc0 =[ 0.57	 % cglc intracellulr  hynne
      0.42   % cg6p  uppmtt
      0.3	 % cf6p  uppmtt
      0.16   % cfbp  uppmtt
      1.4	 % cdhap  berknat frn jmv konst keq=0.045 hynne
      0.063   % cgap  rizzi
      1 % cbpg hynne
      0.053  % cpep  rizzi
      0.22	 % cpyr  uppmtt
      1.41	 % caca  hynne
      0.01	 % cetoh uppmtt
      9.90	 % cglyc uppmtt
      1.79	 % catp  uppmtt
      1.49	 % cadp  uppmtt
      0.096   %nadh    uppskattat
      0.62   %amp    uppmtt
      174.4]; % biomassa  uppmtt
c=C.*conc0;




cglc = c(1);
cg6p = c(2);
cf6p = c(3);
cfbp = c(4);
cdhap = c(5);
cgap = c(6);
cbpg = c(7);
cpep = c(8);
cpyr = c(9);
caca = c(10);
cetoh = c(11);
cglyc = c(12);
catp = c(13);
cadp = c(14);
cnadh = c(15);
camp = c(16);
cbiomass = c(17);
%-------------------------------
%ANDRA KONSTANTER OCH KONSERVERADE ENHETER
%-------------------------------

yvol = 37;  %medel fr hela experimentet
Y0=yvol;
litercellpergDW = 0.002; %l cell/g DW

cnad = 2.97 - cnadh;  %Konserverad pool av NAD/NADH
%camp = 3.9-cadp-catp; %0.4;          %Konstant niv av AMP



%-------------------------------
%GLUKOSUPPTAG
%-------------------------------

pGLuc =[-0.00787082110603  -0.22224366063227];
pO2fas1 =[0.00001957906123  -0.00071069928148   0.00859821126748   0.06224475496663];
pO2fas2 =[0.00000002968935  -0.00000849637484   0.00072378689414   0.08901820080169];
pBiom =[0.00016840490881  -0.00190247635151  12.33876925953324];
v1 = -1*polyval (pGluc,t);
biomasskons = polyval(biom,t);
V1 = v1/biomasskons/2.0*1000;


%-------------------------------------------
%TIDSSPECIFIKA HASTIGHETER
%-------------------------------------------

if t < 5
    rO2 = 0.05571/2e-3; %mM/min O2 frbrukning
   
end

if ( t >= 5 & t<15)
    rO2 = 0.0609/2e-3; %O2 frbrukning
  
end

if ( t>=15 & t<30)
    rO2 = 0.0876/2e-3; %O2 frbrukning
  
end

if (t>=30 & t<60)
    rO2 = 0.0971/2e-3; %O2 frbrukning
   
end

if (t>=60 & t<=120)
    rO2 = 0.1/2e-3; %O2 frbrukning
    
end

if t>=120
    rO2 = 0.109/2e-3; %O2 fbrukning
    
end


%----------------------------------------------------
%GLUKOSTRANSPORT
%----------------------------------------------------

vglctrans = V1;
%---------------------------------------------------


%---------------------------------------------------
%HEXOKINASE
%---------------------------------------------------
%v3m = 5.17547*10;
%v3m = 6.5712e-1;
K3DGlc = 0.37;
K3Glc = 0;
K3atp =0.1;
vhk = v3m*catp*cglc / ((K3DGlc*K3atp) + (K3Glc*catp) + (K3atp*cglc) + (cglc*catp));
%---------------------------------------------------


%---------------------------------------------------
%PHOSPHOGLUCOISOMERAS
%---------------------------------------------------
%v4m = 4.96042e2;
%v4m = 7.5189e2;
K4g6p = 0.8;
K4f6p = 0.15;
K4eq = 0.13;
vpgif = v4m * cg6p / ( K4g6p + cg6p + (K4g6p*cf6p/K4f6p) );
vpgib = v4m * (cf6p / K4eq) / ( K4g6p + cg6p + (K4g6p*cf6p/K4f6p) );
vpgi = vpgif - vpgib;
%-----------------------------------------------------


%-----------------------------------------------------
%PHOSPFOFRUCTOKINASE
%-----------------------------------------------------
%v5m = 4.54327e1;
%v5m = 1.2418e1;
k5 = 0.15;   
K5 = 0.021;
vpfk = v5m * cf6p*cf6p / ( K5*(1+(k5*catp*catp/(camp*camp))) + (cf6p*cf6p) );
%-----------------------------------------------------


%-----------------------------------------------------
%ALDOLASE
%-----------------------------------------------------
%v6f = 2.20782e3;
%v6f = 1.6;
V6r = 5*v6f; % 1.10391e4;
%PER DEFENITION SKA v6r/v6f= 5
K6fbp = 0.3;
K6DHAP = 2.0;
K6eq = 0.081;
K6gap = 4.0;
K6Igap =10.0;
valdf = v6f*cfbp/ ( K6fbp + cfbp + (cgap*K6DHAP*v6f / (K6eq*V6r)) + (cdhap*K6gap*v6f / (K6eq*V6r)  ) + (cfbp*cgap/K6Igap) + (cgap*cdhap*v6f/(K6eq*V6r)));
valdb = v6f*(cgap*cdhap/K6eq) / ( K6fbp + cfbp + (cgap*K6DHAP*v6f / (K6eq*V6r)) + (cdhap*K6gap*v6f / (K6eq*V6r)  ) + (cfbp*cgap/K6Igap) + (cgap*cdhap*v6f/(K6eq*V6r)));
vald = valdf - valdb;
%-----------------------------------------------------


%-----------------------------------------------------
%TRIOSEPHOSPHATISOMERAS
%-----------------------------------------------------
v7m =1.16365e2;
%v7m = 9.9955e5;
K7dhap = 1.23;
K7gap = 1.27;
K7eq = 0.065;
vtimf = v7m * cdhap / ( K7dhap + cdhap + (K7dhap*cgap/K7gap));
vtimb = v7m * (cgap/K7eq) / ( K7dhap + cdhap + (K7dhap*cgap/K7gap));
vtim = vtimf - vtimb;
%------------------------------------------------------


%------------------------------------------------------
%GLYCERALDEHYDE 3-PHOSPHATE DEHYDROGENASE
%------------------------------------------------------
v8m = 8.33858e2;
%v8m = 9.999e5;
K8gap = 0.6;
K8bpg = 0.01;
K8nad = 0.1;
K8nadh = 0.06;
K8eq = 0.0055;
vgapdhf = v8m * cgap * cnad / ( K8gap*K8nad*(1 + (cgap/K8gap) + (cbpg/K8bpg))*(1 + (cnad/K8nad)+(cnadh/K8nadh)) );
vgapdhb = v8m * (cbpg*cnadh/K8eq) / ( K8gap*K8nad*(1 + (cgap/K8gap) + (cbpg/K8bpg))*(1 + (cnad/K8nad)+(cnadh/K8nadh)) );
vgapdh = vgapdhf-vgapdhb;
%-------------------------------------------------------


%-------------------------------------------------------
%LP-PEP
%-------------------------------------------------------
%k9f = 4.43866e5;
k9f = 1.0086e5;    %fitri
%k9r = 1.52862e2;
k9r = 7.3909e2;  %fitri
vpepf = k9f*cbpg*cadp;
vpepb = k9r*cpep*catp;
vpep = vpepf - vpepb;
%-------------------------------------------------------


%-------------------------------------------------------
%PYRUVATKINASE
%-------------------------------------------------------
%v10m = 3.43e2;
%v10m = 8.6027e1;
K10pep = 0.2;
K10adp = 0.17;
vpk = v10m * cadp * cpep / ( (K10pep + cpep)*(K10adp + cadp) );
%-------------------------------------------------------


%-------------------------------------------------------
%PYRUVATE DECARBOXYLASE
%-------------------------------------------------------
%v11m =5.31328e1;
%v11m = 6.5459;
K11 = 0.3;
vpdc = (v11m * cpyr)/(K11 + cpyr);
%-------------------------------------------------------


%-------------------------------------------------------
%ALCOHOL DEHYDROGENASE
%-------------------------------------------------------
%v12m =8.98023e1;
%v12m = 1.0015;
K12nadh =0.1;
K12aca = 0.71;
vadh = v12m * caca * cnadh / ( (K12nadh+cnadh) * (K12aca+caca) ); 
%-------------------------------------------------------


%-------------------------------------------------------
%DIFFUSION OF ETHANOL
%AVSTNGD ACKUMULATION SOM ANVNDS FR MINIMERINGEN
%-------------------------------------------------------
k13 = 1.6720e1;
% vdiffef = k13*cetoh;
% vdiffeb = k13*ceetoh;
V12 = 0;%0.3804; 
vdetoh = V12*Y0;
%-------------------------------------------------------


%-------------------------------------------------------
%LPGLYCEROL
%-------------------------------------------------------
%v15m = 8.14797e1;
%v15m = 8.147e1;
K15dhap = 25;
K15inadh =0.034;
K15inad =0.13;
K15nadh = 0.13;
del1 = K15dhap*(1 + ((K15inadh/cnadh)*(1+(cnad/K15inad))));
del2 = cdhap *(1 + ((K15nadh/cnadh)*(1+(cnad/K15inad))));
vgpd = (v15m*cdhap)/(del1+del2);
%-------------------------------------------------------


%-------------------------------------------------------
%DIFFUSION OF GLYCEROL
%AVSTNGD ACKUMULATION SOM ANVNDS FR MINIMERINGEN
%-------------------------------------------------------
k16 = 1.9;
V15 = 0;%0.0833;
vdglyc = V15*Y0;
%-------------------------------------------------------


%------------------------------------------------------
%STORAGE
%------------------------------------------------------
%k22 = 2.25932;
k22 = 1.8614e1;
vstor = 0;% k22*catp*cg6p;
%------------------------------------------------------


%------------------------------------------------------
%ATP Comsumption
%------------------------------------------------------
%k23 = 3.20760;
%k23 = 2.7099e1;
vcons = k23 * catp;
%------------------------------------------------------


%------------------------------------------------------
%ADENYLATKINASE
%-------------------------------------------------------
%k24f = 4.329e2;
%k24f = 4.6432;
%k24r = 1.33333e2;
%k24r = 1.6912;
vakf = k24f*camp*catp ;
vakb = k24r * cadp * cadp;
vak = vakf - vakb;
%-----------------------------------------------------


%-----------------------------------------------------
%ADDITONAL REACTIONS
%-----------------------------------------------------
vbiomass = kbio; %mM/cell*min
vtca = vpk-vpdc-0.202*vbiomass; %kco2 - vpdc-0.202*vbiomass; %/TCA-cycle
vresp = 2*rO2; %respiration

%-----------------------------------------------------



%-----------------------------------------------------
%MASSBALANSER
%-----------------------------------------------------

dcglc = vglctrans - vhk;
dcg6p = vhk - vpgi - vstor - 0.088*vbiomass;
dcf6p = vpgi - vpfk - 0.0042*vbiomass;
dcfbp = vpfk - vald;
dcdhap = vald - vtim - vgpd;
dcgap = vald + vtim - vgapdh - 0.078*vbiomass;   
dcbpg = vgapdh - vpep - 0.090*vbiomass;
dcpep = vpep - vpk - 0.0312*vbiomass;
dcpyr = vpk - vpdc - vtca - 0.555*vbiomass;
dcaca = vpdc - vadh;
dcetoh = vadh ;
dcglyc = vgpd ;

dcatp = vresp + vpep + vpk - vhk - vpfk - vcons - 2.74*vbiomass - vak-vstor;
dcadp = vhk + vstor  + vcons + vpfk - vpep - vpk - vresp + 2.52*vbiomass + 2*vak;
dcnadh = -(vgpd + 10*vresp +vadh - vgapdh - 5*vtca - 0.79*vbiomass);
dcbiomassa = vbiomass*cbiomass*(litercellpergDW);
dcamp = 0.224*vbiomass - vak;

%-----------------------------------------------------
%SAMLING AV MASSBALANSER
%-----------------------------------------------------
% t;
['vglctrans vhk vpgi vpfk vald vtim vgpd vgapdh vpep vpk vpdc vadh vtca vcons vresp vbiomass'];
['1           2  3     4   5    6    7    8      9    10  11   12   13   14    15    16'] ;
v=[vglctrans
    vhk
    vpgi
    vpfk
    vald
    vtim
    vgpd
    vgapdh
    vpep
    vpk
    vpdc
    vadh
    vtca
    vcons
    vresp
    vbiomass];


dcdt = [dcglc
        dcg6p
        dcf6p
        dcfbp
        dcdhap
        dcgap
        dcbpg
        dcpep
        dcpyr
        dcaca
        dcetoh
        dcglyc
        dcatp
        dcadp
        dcnadh
        dcamp       
        dcbiomassa];
 
  dCdt=dcdt;%./conc0  ;
    

%----------------------------------------------------
