function min = funwt(X)


% f-fil fr hynneparam

global g6pm f6pm fbpm pyrm adpm atpm nadm etohm glycm DWm co2m ampm time calc
global v3m v4m v5m v6f v8m v10m v11m v12m v15m k23 k24f k24r kbio kco2

%assossiera hastighetskonstaterna med rtt vrde
x=X;
v3m = x(1);
v4m = x(2);
v5m = x(3);
v6f = x(4);
v8m = x(5);
v10m = x(6);
v11m = x(7);
v12m = x(8);
v15m = x(9);
k23 = x(10);
kbio = x(11);
kco2 = x(12);
k24f = x(13);
k24r = x(14);
%---------------------------------
%initialvrden
%---------------------------------

%Startgissningar
% conc0 =[ 0.57	 % cglc intracellulr  hynne
%       0.42   % cg6p  uppmtt
%       0.3	 % cf6p  uppmtt
%       0.16   % cfbp  uppmtt
%       1.4	 % cdhap  berknat frn jmv konst keq=0.045 hynne
%       0.063   % cgap  rizzi
%       1 %0.00027 % cbpg hynne
%       0.053  % cpep  rizzi
%       0.22	 % cpyr  uppmtt
%       1.41	 % caca  hynne
%       0.01	 % cetoh uppmtt
%       9.90 %0.01	 % cglyc uppmtt
%       1.79	 % catp  uppmtt
%       1.49	 % cadp  uppmtt
%       0.096   %nadh    uppskattat
%       0.62   %amp    uppmtt
%       174.4]; % biomassa  uppmtt
  

 conc0 =[ 1	 %cglc intracellulr  hynne
      1   %cg6p  uppmtt
      1	 %cf6p  uppmtt
      1   %cfbp  uppmtt
      1	 %cdhap  berknat frn jmv konst keq=0.045 hynne
      1   %cgap  rizzi
      1 %cbpg hynne
      1  %cpep  rizzi
      1	 %cpyr  uppmtt
      1	 %caca  hynne
      1	 %cetoh uppmtt
      1	 %cglyc uppmtt
      1	 %catp  uppmtt
      1	 %cadp  uppmtt
      1   %nad    uppmtt
      1   %amp    uppmtt
      1]; %biomassa  uppmtt 


%--------------------------------
%Avdelning fr ode-lsare
%--------------------------------



options = odeset('RelTol', 1e-6, 'AbsTol', 1e-7);
[time, calc]=ode15s('mbwt', [0 10], conc0,options)
plot (time, calc);
legend ( ' cglc','cg6p','cf6p','cfbp','cdhap','cgap','cbpg','cpep ','cpyr','caca','cetoh','cglyc',' catp','cadp',' nadh', 'amp', 'biomass');

%---------------------------------
%Berkna CO2 hastigheter i mtpunkter
%---------------------------------
cco2 = hynnespeed(calc)



%---------------------------------
%SORTERING AV DATA
%---------------------------------
% 37 = yvol medel fr hela experimentet
g6p = calc(2:6,2);
f6p = calc(2:6,3);
fbp = calc(2:6,4);
pyr = calc(2:6,9);
atp = calc(2:6,13);
adp = calc(2:6,14);
amp = calc(2:6,16);
nad = calc(2:6,15);
etoh = calc(2:6,11)./37;
glyc = calc(2:6,12)./37;
DW  = calc(2:6,17);
co2  = cco2(2:6,:);

%---------------------------------
%MINIMERINGSUTRYCK
%---------------------------------
min = [g6p - g6pm
       f6p - f6pm
       fbp - fbpm
       pyr - pyrm
       adp - adpm
       atp - atpm
       nad - nadm
       etoh - etohm
       glyc - glycm
       DW   - DWm
       amp  - ampm];

 