% -----------------------------------------------------------------------
% CALCULATING THE JACOBIAN MATRIX OF OUR KINETIC MODEL
% -----------------------------------------------------------------------

% -----------------------------------------------------------------------
% Author: Ahmad Abdullah Mannan (c)
% Date: April 2014
% Affiliation : Faculty of Health and Medical Sciences, University of
% Surrey, Guildford, GU2 7TE, UK.
% -----------------------------------------------------------------------

%function Jacobian = SystemJacobian(f,x0,paramAdj)
function Jacobian = SystemJacobian(f,x0)
% The system is given by function = f.
% The steady state vector about which the Jacobian is evaluated = x0.

%f_x0 = feval(f,[],x0,paramAdj);
 f_x0 = feval(f,[],x0);
eps = 1e-10; % The smaller this is the better the approximation to the Jacobian

Jacobian = zeros(length(x0)); % Empty Jacobian Matrix
for i = 1:length(x0)
    x_perturb = x0;
    x_perturb(i) = x_perturb(i) + eps;
    % Filling the Jacobian estimated values column by column:
    %Jacobian(:,i) = (feval(f,[],x_perturb,paramAdj) - f_x0) / eps; % Partial derivative in ith row
    Jacobian(:,i) = (feval(f,[],x_perturb) - f_x0) / eps;
end
