%#########################################################################
%#             FUNCTION  for ODE -iN HOURS                    
%#########################################################################
function y = WTBC_ode(t,C)
parameter_ori;
global POrate
global k_ATP
global Xm

NUM =size(C);
for i=1:NUM
    if C(i) <=0.0
        C(i)=0.0;
    end
end

X       = C(1,:); 
GLCex   = C(2,:);       % in mM/h
G6P     = C(3,:); 
F6P     = C(4,:); 
FDP     = C(5,:); 
GAPDHAP = C(6,:);  
PEP     = C(7,:);
PYR     = C(8,:);
ACCOA   = C(9,:);
ICIT    = C(10,:);
C2KG    = C(11,:);
SUC     = C(12,:);
FUM     = C(13,:);
MAL     = C(14,:);
OAA     = C(15,:);
GOX     = C(16,:);
ACP     = C(17,:);
ACET    = C(18,:);
C6PG    = C(19,:);
Ru5P    = C(20,:);
R5P     = C(21,:);
Xu5P    = C(22,:);
S7P     = C(23,:);
E4P     = C(24,:);

if (ACET <0.0)
        ACET=0.0;
end

if (GLCex <0.0)
        GLCex=0.0;
end



r_PTS   = (V_PTSmax*GLCex*PEP/PYR)/( (K_PTSa1+(K_PTSa2*PEP/PYR)+(K_PTSa3*GLCex)+(GLCex*PEP/PYR)) * (1 + (G6P^n_PTSg6p/K_PTSg6p)) );
r_PGI   = (V_PGImax*(G6P-(F6P/K_PGIeq)))/( K_PGIg6p* (1+(F6P/(K_PGIf6p*(1+C6PG/K_PGIf6p_6pginh)))+(C6PG/K_PGIg6p_6pginh))+ G6P );
A = 1 + (PEP/K_PFKpep) + (ADP/K_PFKadp_b) + (AMP/K_PFKamp_b);
B = 1 + (ADP/K_PFKadp_a) + (AMP/K_PFKamp_b);
r_PFK = (V_PFKmax*ATP*F6P)/((ATP+K_PFKatp_s*(1+ADP/K_PFKadp_c))*(F6P+K_PFKf6p_s*(A/B))*(1+L_PFK/(1+F6P*(B/(K_PFKf6p_s*A)))^n_PFK ) );  %original kinetic equation
%r_PFK = (V_PFKmax*ATP*F6P)/( (ATP+K_PFKatp_s*(1+ADP/K_PFKadp_c))*(F6P+K_PFKf6p_s*(A/B)) );
%r_ALDO  =(V_ALDOmax*FDP-(GAPDHAP/K_ALDOeq))/(K_ALDOfdp+FDP+((K_ALDOgap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+((K_ALDOdhap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+(FDP*GAPDHAP/K_ALDOgapinh)+(GAPDHAP/(K_ALDOeq*V_ALDOblf)));
r_ALDO  =(V_ALDOmax*FDP-(GAPDHAP*GAPDHAP/K_ALDOeq))/(K_ALDOfdp+FDP+((K_ALDOgap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+((K_ALDOdhap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+(FDP*GAPDHAP/K_ALDOgapinh)+(GAPDHAP*GAPDHAP/(K_ALDOeq*V_ALDOblf)));
r_GAPDH =(V_GAPDHmax*(GAPDHAP-((PEP*NADH)/(K_GAPDHeq*NAD))))/((K_GAPDHgap*(1+(PEP/K_GAPDHpgp))+GAPDHAP)*((K_GAPDHnad/NAD)*(1+(NADH/K_GAPDHnadh))+1));
r_PYK   =(V_PYKmax*PEP*(((PEP/Km_PYKpep)+1)^n_PK)*ADP)/(Km_PYKpep*(L_PYK *(((1+ATP/Km_PYKatp)/((FDP/Km_PYKfdp)+(AMP/Km_PYKamp)+1))^n_PYK)+((PEP/Km_PYKpep +1)^n_PYK))*(ADP +Km_PYKadp));
r_PDH   = (V_PDHmax2*(1/(NAD+(Ki_PDH2*NADH)))*(PYR/Km_PDHpyr2)*(NAD/Km_PDHnad2)*(COA/Km_PDHcoa2))/((1+(PYR/Km_PDHpyr2))*((1/NAD)+(1/Km_PDHnad2)+(NADH/(NAD*Km_PDHnadh2)))*(1+(COA/Km_PDHcoa2)+(ACCOA/Km_PDHaccoa2)));
%%r_CS    =(CSmax*ACCOA*OAA)/(((Kd_CSaccoa*Km_CSoaa+Km_CSaccoa*OAA)*(1+ATP/Ki_CSatp))+(ACCOA*Km_CSoaa*(1+(C2KG/Ki1_CS2kg)+(NADH/Ki1_CSnadh)))+(ACCOA*OAA*(1+(C2KG/Ki2_CS2kg)+(NADH/Ki2_CSnadh))));
pH=7.0;
H=10^((-1)*pH);
r_CS = (V_CSmax*(1+(Kd1_CSh/H)+(H/Kd2_CSh))*ACCOA*OAA) / (((Kd_CSaccoa*Km_CSoaa+Km_CSaccoa*OAA)*(1+(Kd1_CSh/H)+((H/Kd2_CSh)*(1+ATP/Ki_CSatp)))) + (ACCOA*Km_CSoaa*(1+(Kd1_CSh/H)+(H/Kd2_CSh)+(C2KG/Ki1_CS2kg)+(NADH/Ki1_CSnadh)))+(ACCOA*OAA*(1+(Kd1_CSh/H)+(H/Kd2_CSh)+(C2KG/Ki2_CS2kg)+(NADH/Ki2_CSnadh))));
r_ICDH  =(ICDH*(Kf_ICDH/Km_ICDHicit)*Kd_ICDHnadp*(ICIT-(NADPH*C2KG/(Keq_ICDH*NADP))))/((1/NADP)+(ICIT*Km_ICDHnadp/(Km_ICDHicit*Kd_ICDHnadp*NADP))+(1/Kd_ICDHnadp)+(ICIT/(Km_ICDHicit*Kd_ICDHnadp))+((ICIT/(Kd_ICDHicit*NADP))*((NADPH*Km_ICDHnadp)/(Km_ICDHicit*Kd_ICDHnadp*Keinh_ICDHnadph)))+((NADPH*Keknh_ICDH2kg)/(Km_ICDH2kg*Kenhe_ICDHnadph*NADP))+((C2KG*Km_ICDHnadph)/(Km_ICDH2kg*Kenhe_ICDHnadph*NADP))+((C2KG/Km_ICDH2kg)*(NADPH/(Kenhe_ICDHnadph*NADP)))+ (((C2KG*Km_ICDHnadph)/(Km_ICDH2kg*Kenhe_ICDHnadph))*(NADPH/(Kekn_ICDHnadp*NADP))));
r_2KGDH =(V_2KGDHmax*C2KG*COA)/( ((K_2KGDHnad*C2KG*COA)/NAD)+(K_2KGDHcoa*C2KG)+(K_2KGDH2kg*COA)+(C2KG*COA)+((K_2KGDH2kg*K_2KGDHz*SUC*NADH)/(K_2KGDHsuc*NAD))+((K_2KGDHnad*C2KG*COA*NADH)/(K_2KGDHnadh*NAD))+ ((K_2KGDHcoa*C2KG*SUC)/K_2KGDHsuc)+((K_2KGDH2kg*K_2KGDHz*C2KG*SUC*NADH)/(KI_2KGDH2kg*K_2KGDHsuc*NAD)) );
r_SDH   =(V_SDH1*V_SDH2*(SUC-(FUM/Keq_SDH)))/((Km_SDHsuc*V_SDH2)+(V_SDH2*SUC)+(V_SDH1*FUM/Keq_SDH));
r_FUM   =(V_FUM1*V_FUM2*(FUM-(MAL/Keq_FUM)))/((Km_FUM*V_FUM2)+(V_FUM2*FUM) + (V_FUM1*MAL/Keq_FUM)); 
r_MDH   =(V_MDH1*V_MDH2*(MAL-(OAA/Keq_MDH)))/( ((KI_MDHnad*Km_MDHmal*V_MDH2)/NAD) + (Km_MDHmal*V_MDH2)+((Km_MDHnad*V_MDH2*MAL)/NAD)+ (V_MDH2*MAL)+((Km_MDHoaa*V_MDH1*NADH)/(Keq_MDH*NAD))+ ((Km_MDHnadh*V_MDH1*OAA)/(Keq_MDH*NAD))+((V_MDH1*NADH*OAA)/(Keq_MDH*NAD))+((V_MDH1*Km_MDHoaa*NADH)/(Keq_MDH*KI_MDHnad))+((V_MDH2*Km_MDHnad*MAL*OAA)/(KI_MDHoaa*NAD))+((V_MDH2*MAL*NADH)/KI_MDHnadh)+((V_MDH1*MAL*NADH*OAA)/(Keq_MDH*KI_MDHmal*NAD))+((V_MDH2*MAL*OAA)/KII_MDHoaa)+((V_MDH1*NADH*OAA)/(KII_MDHnad*Keq_MDH))+((KI_MDHnad*V_MDH2*MAL*NADH*OAA)/(KII_MDHnad*Km_MDHoaa*KI_MDHnadh))) ; 
%r_ICL   =(r_ICLmax_f*(ICIT/K_ICLicit))/(1+(ICIT/K_ICLicit)+(SUC/K_ICLsuc)+(GOX/K_ICLgox)+((ICIT/K_ICLicit)*(SUC/K_ICLsuc))+((SUC/K_ICLsuc)*(GOX/K_ICLgox))+(I/KI_ICL));
r_ICL = (V_ICLmax*(ICIT/K_ICLicit)) / ((1+(ICIT/K_ICLicit))*(1+(SUC/K_ICLsuc)+(PEP/K_ICLpep)+(C2KG/K_ICL2kg)));
%r_MS    =(Vf_MS*(GOX/Km_MSgox)*(ACCOA/Km_MSaccoa))/((1+(GOX/Km_MSgox) +(MAL/Km_MSmal))*(1+ACCOA/Km_MSaccoa));
r_MS = (V_MSmax*(GOX/Km_MSgox)*(ACCOA/Km_MSaccoa))/((1+(GOX/Km_MSgox))*(1+(ACCOA/Km_MSaccoa)) );
r_PTA   =(V_PTAmax*(1/(Ki_PTAaccoa*Km_PTAp))*((ACCOA*P)-(ACP*COA/Keq_PTA)))/(1+(ACCOA/Ki_PTAaccoa)+(P/Ki_PTAp)+(ACP/Ki_PTAacp)+(COA/Ki_PTAcoa)+((ACCOA*P)/(Ki_PTAaccoa*Km_PTAp))+((ACP*COA)/(Km_PTAacp*Ki_PTAcoa))); 
r_ACK   =(V_ACKmax*(1/Km_ACKadp*Km_ACKacp)*((ACP*ADP)-(ACET*ATP/Keq_ACK)))/( (1+(ACP/Km_ACKacp)+(ACET/Km_ACKacet))*(1+(ADP/Km_ACKadp)+(ATP/Km_ACKatp)) );
r_ACS   = (V_ACSmax*ACET*NADP)/(Km2_ACS+ACET)*(Keq_ACS+NADP);
r_MEZ   =(V_MEZ*MAL*NADP)/((Km_MEZmal+ MAL)*(Keq_MEZ+NADP));
r_PCK   =(V_PCKmax*OAA*(ATP/ADP))/( (Km_PCKoaa*(ATP/ADP)) +(OAA*(ATP/ADP))+(Ki_PCKatp*Km_PCKoaa/Ki_PCKadp)+((Ki_PCKatp*Km_PCKoaa*PEP)/(Km_PCKpep*Ki_PCKadp))+((Ki_PCKatp*Km_PCKoaa/(Ki_PCKpep*KI_PCKatp))*(ATP*PEP/ADP))+((Ki_PCKatp*Km_PCKoaa)/(Ki_PCKadp*KI_PCKoaa)*OAA));
r_PPC   = V_PPCmax2*((k1+(k2*ACCOA)+(k3*FDP)+(k4*ACCOA*FDP))/(1+(k5*ACCOA)+(k6*FDP)))*(PEP/(Km_PEP+PEP)); %Lee

r_G6PDH = (V_G6PDHmax*G6P)/((G6P+K_G6PDHg6p)*(1+(NADPH/K_G6PDHnadphg6pinh))*((K_G6PDHnadp/NADP)*(1+NADPH/K_G6PDHnadphnadpinh)+1));
r_6PGDH = (V_6PGDHmax*C6PG)/((C6PG+K_6PGDH6pg)*(1+(K_6PGDHnadp/NADP)*(1+(NADPH/K_6PGDHnadphinh))*(1+(ATP/K_6PGDHatpinh))));
r_RPE  = V_RPEmax*(Ru5P-(Xu5P/K_RPEeq));
r_RPI  = V_RPImax*(Ru5P-(R5P/K_RPIeq));
r_TKTA = V_TKTAmax*((R5P*Xu5P)-(S7P*GAPDHAP/K_TKTAeq));
r_TKTB = V_TKTBmax*((Xu5P*E4P)-(F6P*GAPDHAP/K_TKTBeq));
r_TAL  = V_TALmax*((GAPDHAP*S7P)-(E4P*F6P/K_TALeq));
 
r_CO2   = r_PDH+r_PCK+r_ICDH+r_2KGDH+r_MEZ+r_6PGDH-r_PPC;
OP_NADH = (r_GAPDH+r_PDH+r_ICDH+r_2KGDH+r_MDH)*POrate;  %%%%2.5
OP_FADH = r_SDH*1.5;
r_ATP   = OP_NADH+OP_FADH+r_GAPDH+r_PYK+r_ACK+r_SDH-r_PFK-r_PCK;

n=1;
Sf=S_f*180/1000; 
miu  =miu_Max*((1-X/Xm)^n)*((GLCex*180/1000)/(K_Xs+GLCex*180/1000))*k_ATP*r_ATP; %original
%miu  =(miu_Max*GLCex*180/1000)/(K_Xs+GLCex*180/1000)*k_ATP*r_ATP;  

%% ----------------------------------------------------------------------
%% Include some rule based for Acetate Production and consumption
%% ----------------------------------------------------------------------
minGlc =3; % 1g/l=5.56mM
if ((GLCex<=minGlc)&&(ACET>=0)) 
    miu    =(miu_Max*((1-X/Xm)^n)*((ACET*60/1000)/(K_ACETs+ACET*60/1000))*k_ATP*r_ATP) + ...
            (miu_Max*((1-X/Xm)^n)*((GLCex*180/1000)/(K_Xs+GLCex*180/1000))*k_ATP*r_ATP); 
    %miu   =((miu_Max*ACET*60/1000)/(K_ACETs+ACET*60/1000)*k_ATP*r_ATP); 
           
  	cra  = 1;   % cra activate
	fadR = 0;   % fadR repress
	iclR = 0;   % iclR repress
    r_ACS = r_ACS*(1-(GLCex/minGlc)); % Acs active   
    r_MEZ = r_MEZ;
    r_PCK = r_PCK;
    r_ACK = r_ACK*(GLCex/minGlc); %
    r_PTA = r_PTA*(GLCex/minGlc); %
else
    cra  = 0;   % cra repress
	fadR = 1;   % fadR actived
	iclR = 1;   % iclR actived
    r_ACS = 0;  % Acs inactive  
    r_MEZ = 0;  % mez inactive 
    r_PCK = 0;  % pck inactive 
end

if (r_PPC==0)
    r_ACK = 0; %
    r_PTA = 0; %
    cra  = 1;   % cra repress
	fadR = 0;   % fadR actived
	iclR = 0;   % iclR actived
end

% if (r_PCK==0)
%     cra  = 1;   % cra repress
% 	fadR = 0;   % fadR actived
% 	iclR = 0;   % iclR actived
% end

if (cra==1)	
	aceA = 1;   % {Icl active}
    aceB = 1;   % {MS active}
elseif (cra==0)
	aceA = 0;   % {Icl repress}
    aceB = 0;   % {MS repress}
end

if ((fadR==0)&(iclR==0))
	aceA = 1; %   {Icl active}
	aceB = 1; %   {MS active}	
    aceK = 1; %   {ICDH repress}   
elseif ((fadR==1)&(iclR==1))
	aceA = 0; %   {Icl repress }
	aceB = 0; %   {MS repress }	
    aceK = 0; %   {ICDH active}   
end

%-----ICL -----------
if (aceA==1)
    r_ICL = r_ICL; 
elseif (aceA==0)
    r_ICL =0;
end

%------MS------------
if (aceB==1)
    r_MS = r_MS;
elseif (aceB==0)
    r_MS=0;
end

if (GLCex<=minGlc)
    r_ACK = r_ACK*(GLCex/minGlc); %
    r_PTA = r_PTA*(GLCex/minGlc); %
end

y=[miu*X                                        %1. BIOMASS
    -r_PTS*X                           %2. GLCextra - ((S_f-GLCex)*D)-r_PTS*X      
    (r_PTS-r_PGI-r_G6PDH)*X-(miu*G6P)                 %3. G6P
    (r_PGI+r_TKTB+r_TAL-r_PFK)*X-(miu*F6P)            %4. F6P
    (r_PFK-r_ALDO)*X-(miu*FDP)                        %5. FDP     
    (2*r_ALDO+r_TKTA+r_TKTB-r_TAL-r_GAPDH)*X-(miu*GAPDHAP)   %6. GAP/DHAP
    (r_GAPDH+r_PCK-r_PTS-r_PYK-r_PPC)*X-(miu*PEP)     %7. PEP     
    (r_PYK+r_PTS+r_MEZ-r_PDH)*X-(miu*PYR)             %8. PYR   
    (r_PDH+r_ACS-r_CS-r_PTA)*X-(miu*ACCOA)            %9. ACCOA 
    (r_CS-r_ICDH-r_ICL)*X-(miu*ICIT)                  %10. ICIT 
    (r_ICDH-r_2KGDH)*X-(miu*C2KG)                     %11. 2KG
    (r_2KGDH+r_ICL-r_SDH)*X-(miu*SUC)                 %12. SUC
    (r_SDH-r_FUM)*X-(miu*FUM)                         %13. FUM
    (r_FUM+r_MS-r_MDH-r_MEZ)*X-(miu*MAL)              %14. MAL
    (r_MDH+r_PPC-r_CS-r_PCK)*X-(miu*OAA)              %15. OAA   
    (r_ICL-r_MS)*X-(miu*GOX)                          %16. GOX
    (r_PTA-r_ACK)*X-(miu*ACP)                         %17. ACP   
    (r_ACK-r_ACS)*X                    %18. ACET
    (r_G6PDH-r_6PGDH)*X-(miu*C6PG)                    %19. 6PG
    (r_6PGDH-r_RPE-r_RPI)*X-(miu*Ru5P)                %20. Ru5P
    (r_RPI-r_TKTA)*X-(miu*R5P)                        %21. R5P
    (r_RPE-r_TKTA-r_TKTB)*X-(miu*Xu5P)                %22. Xu5P
    (r_TKTA-r_TAL)*X-(miu*S7P)                        %23. S7P
    (r_TAL-r_TKTB)*X-(miu*E4P)  ];                    %24. E4P


% y=[miu*X                                        %1. BIOMASS
%     -r_PTS*X                           %2. GLCextra - ((S_f-GLCex)*D)-r_PTS*X      
%     (r_PTS-r_PGI-r_G6PDH-miu*G6P)*X                 %3. G6P
%     (r_PGI+r_TKTB+r_TAL-r_PFK-miu*F6P)*X            %4. F6P
%     (r_PFK-r_ALDO-miu*FDP)*X                        %5. FDP     
%     (2*r_ALDO+r_TKTA+r_TKTB-r_TAL-r_GAPDH-miu*GAPDHAP)*X   %6. GAP/DHAP
%     (r_GAPDH+r_PCK-r_PTS-r_PYK-r_PPC-miu*PEP)*X     %7. PEP     
%     (r_PYK+r_PTS+r_MEZ-r_PDH-miu*PYR)*X             %8. PYR   
%     (r_PDH+r_ACS-r_CS-r_PTA-miu*ACCOA)*X            %9. ACCOA 
%     (r_CS-r_ICDH-r_ICL-miu*ICIT)*X                  %10. ICIT 
%     (r_ICDH-r_2KGDH-miu*C2KG)*X                     %11. 2KG
%     (r_2KGDH+r_ICL-r_SDH-miu*SUC)*X                 %12. SUC
%     (r_SDH-r_FUM-miu*FUM)*X                         %13. FUM
%     (r_FUM+r_MS-r_MDH-r_MEZ-miu*MAL)*X              %14. MAL
%     (r_MDH+r_PPC-r_CS-r_PCK-miu*OAA)*X              %15. OAA   
%     (r_ICL-r_MS-miu*GOX)*X                          %16. GOX
%     (r_PTA-r_ACK-miu*ACP)*X                         %17. ACP   
%     (r_ACK-r_ACS)*X                    %18. ACET
%     (r_G6PDH-r_6PGDH-miu*C6PG)*X                    %19. 6PG
%     (r_6PGDH-r_RPE-r_RPI-miu*Ru5P)*X                %20. Ru5P
%     (r_RPI-r_TKTA-miu*R5P)*X                        %21. R5P
%     (r_RPE-r_TKTA-r_TKTB-miu*Xu5P)*X                %22. Xu5P
%     (r_TKTA-r_TAL-miu*S7P)*X                        %23. S7P
%     (r_TAL-r_TKTB-miu*E4P)*X  ];                    %24. E4P


% y=[miu*X                                                %1. BIOMASS
%     -r_PTS*X*1000/564                                   %2. GLCextra - ((S_f-GLCex)*D)-r_PTS*X      
%     r_PTS-r_PGI-r_G6PDH-miu*G6P                         %3. G6P
%     r_PGI+r_TKTB+r_TAL-r_PFK-miu*F6P                    %4. F6P
%     r_PFK-r_ALDO-miu*FDP                                %5. FDP     
%     2*r_ALDO+r_TKTA+r_TKTB-r_TAL-r_GAPDH-miu*GAPDHAP   %6. GAP/DHAP
%     r_GAPDH+r_PCK-r_PTS-r_PYK-r_PPC-miu*PEP             %7. PEP     
%     r_PYK+r_PTS+r_MEZ-r_PDH-miu*PYR                     %8. PYR   
%     r_PDH+r_ACS-r_CS-r_PTA-miu*ACCOA                    %9. ACCOA 
%     r_CS-r_ICDH-r_ICL-miu*ICIT                          %10. ICIT 
%     r_ICDH-r_2KGDH-miu*C2KG                             %11. 2KG
%     r_2KGDH+r_ICL-r_SDH-miu*SUC                         %12. SUC
%     r_SDH-r_FUM-miu*FUM                                 %13. FUM
%     r_FUM+r_MS-r_MDH-r_MEZ-miu*MAL                      %14. MAL
%     r_MDH+r_PPC-r_CS-r_PCK-miu*OAA                      %15. OAA   
%     r_ICL-r_MS-miu*GOX                                  %16. GOX
%     r_PTA-r_ACK-miu*ACP                                 %17. ACP   
%     (r_ACK-r_ACS)*X*1000/564                            %18. ACET
%     r_G6PDH-r_6PGDH-miu*C6PG                            %19. 6PG
%     r_6PGDH-r_RPE-r_RPI-miu*Ru5P                        %20. Ru5P
%     r_RPI-r_TKTA-miu*R5P                                %21. R5P
%     r_RPE-r_TKTA-r_TKTB-miu*Xu5P                        %22. Xu5P
%     r_TKTA-r_TAL-miu*S7P                                %23. S7P
%     r_TAL-r_TKTB-miu*E4P  ];                            %24. E4P
% 
